﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Selected_Text_Demo
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void calcButton_Click(object sender, EventArgs e)
        {
            // Zmienne przechowujące liczbę przepracowanych godzin, stawkę godzinową i wysokość wynagrodzenia.
            decimal hours, payRate, grossPay;

            // Usunięcie wszelkich wyświetlonych ikon błędów.
            ErrorProvider1.SetError(hoursTextBox, "");
            ErrorProvider1.SetError(payRateTextBox, "");

            // Pobranie wprowadzonych wartości i obliczenie wynagrodzenia.
            if (decimal.TryParse(hoursTextBox.Text, out hours))
            {
                if (decimal.TryParse(payRateTextBox.Text, out payRate))
                {
                    // Obliczenie wynagrodzenia.
                    grossPay = hours * payRate;

                    // Wyświetlenie obliczonego wynagrodzenia.
                    grossPayLabel.Text = grossPay.ToString("c");
                }
                else
                {
                    // Nieprawidłowa stawka godzinowa
                    ErrorProvider1.SetError(payRateTextBox,
                        "Stawka godzinowa musi być wartością liczbową.");

                    // Zaznaczenie nieprawidłowych danych wejściowych.
                    payRateTextBox.Focus();
                    payRateTextBox.SelectionStart = 0;
                    payRateTextBox.SelectionLength =
                        payRateTextBox.Text.Length;
                }
            }
            else
            {
                // Nieprawidłowa liczba przepracowanych godzin.
                ErrorProvider1.SetError(hoursTextBox,
                    "Liczba przepracowanych godzin musi być wartością liczbową.");

                // Zaznaczenie nieprawidłowych danych wejściowych.
                hoursTextBox.Focus();
                hoursTextBox.SelectionStart = 0;
                hoursTextBox.SelectionLength =
                    hoursTextBox.Text.Length;
            }
        }
    }
}
